/* Shared Integers API Impelementation */
#include "SHI2.h"

static int segment_id2;
static void *shared_memory2;

int init_integers(int nints)
{
	if ((segment_id2=shmget(IPC_PRIVATE, nints * sizeof(int) ,PERMISSIONS|IPC_CREAT))<0) {
		perror("init_integers: Error in shmget\n");
		return -1;
	}
	shared_memory2 = shmat(segment_id2 , 0 , 0);
	return 0;
}

void shi2_set(int inum, int value)
{
	*((int*)(shared_memory2 + inum*sizeof(int))) = value;
}

int shi2_get(int inum) 
{
	return *((int*)(shared_memory2 + inum*sizeof(int)));
}

int clean_integers()
{
	shmdt(shared_memory2);
	if (shmctl(segment_id2,IPC_RMID,0)) {
		perror("clean_integers: Error in shmctl");
		return -1;
	}
	return 0;
}
