/* Semaphore API Impelementation */
#include "Sem.h"

static int setid;

int init_semaphores(int nsems)
{
	if ((setid=semget(IPC_PRIVATE,nsems,PERMISSIONS|IPC_CREAT))<0) {
		perror("init_semaphores: Error in semget\n");
		return -1;
	}
	return 0;
}

int sem_init(int snum, int value)
{
	int result;
	if (result = semctl(setid,snum,SETVAL,value)<0) {
		perror("sem_init: Error in semctl\n");
		return -1;	
	}
	return result;
}

int clean_semaphores()
{
	if (semctl(setid,0,IPC_RMID)) {
		perror("clean_semaphores: Error in semctl");
		return -1;
	}
	return 0;
}

int sem_signal(int snum)
{
	struct sembuf sop;
	sop.sem_num=snum;
	sop.sem_op=1;
	sop.sem_flg=0;
	if (semop(setid,&sop,1)) {
		perror("sem_signal: Error in semop");
		return -1;
	}
	return 0;
}

int sem_wait(int snum)
{
	struct sembuf sop;
	sop.sem_num=snum;
	sop.sem_op=-1;
	sop.sem_flg=0;
	if (semop(setid,&sop,1)) {
		perror("sem_wait: Error in semop");
		return -1;
	}
	return 0;
}

