/**
	The Server listens through the port 8989 (via a datagram socket).
	Whenever a connection is accepted, they analyze the received message to see its type
	according to type (ALLOC, FREE,  READ,), they decide which action to take.
*//

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include "client.h"

#define LISTEN_PORT 8989
#define SEND_PORT_READ 8893
#define ever ;;

static PageInfo * getPageInfo(int pageID)
{
	static PageInfo pageInfos[64];
	return &(pageInfos[pageID]);
}

void allocatePage(int _pageID, int _pageSize)
{
	unsigned char * _pageData = malloc(_pageSize);
	PageInfo * info = getPageInfo(_pageID);
	//info->pageID = _pageID;
	info->pageSize = _pageSize;
	info->pageData = _pageData;
	info->isReleased = false;
}

void freePage(int _pageID)
{
	PageInfo * info = getPageInfo(_pageID);
	free(info->pageData);
	info->isReleased = true;
}

int readPage(int _pageID, char* buffer)
{
	PageInfo * pageInfo = getPageInfo(_pageID);
	buffer = malloc(pageInfo->pageSize);
	memcpy(replicatedPageInfo->pageData, pageInfo->pageData, pageInfo->pageSize);	
	return 1;
}

void writePage(int pid, int bufferPos, char* msg, int len){
	PageInfo * pageInfo = getPageInfo(_pageID);
	if(pageInfo->pageData != 0)
		free(pageInfo->pageData);
	char newPage[len];
	for (int i=0;i<len-bufferPos;i++){
		newPage[i]=msg[bufferPos+i];
	}
	pageInfo->pageData = newPage;
	pageInfo->pageSize = len - bufferPos;
	pageInfo->isReleased = false;
}

int executeMessage(const char * msg, int len, sockaddr_in sin)
{
	//The message is either ALLOC, FREE, READ, or WRITE
	//The first 4 characters of DSM server message
	char 4firstMsgChars[4];
	for(int i = 0; i < 4; i++)
		4firstMsgChars[i] = msg[i];
	char seps[] = " ";

    if(strcmp(4firstMsgChars, "ALLO") == 0)
	{
		char *token;
		int pID;
		int pSize;
		token = strtok( msg, seps );
		token = strtok(NULL, seps);
		pID = atoi(token);
		token = strtok(NULL, seps);
		pSize = atoi(token);
		allocatePage(pID, pSize);
	}
	else if(strcmp(4firstMsgChars, "FREE") == 0)
	{
		//The command was FREE
		char *token;
		int pID;
		token = strtok( msg, seps );
		token = strtok(NULL, seps);
		pID = atoi(token);
		freePage(pID);
	}
	else if(strcmp(4firstMsgChars, "READ") == 0)
	{
		//The command was READ
		char *token;
		int pID;
		token = strtok( msg, seps );
		token = strtok(NULL, seps);
		pID = atoi(token);
		char * buffer
		readPage(pID,buffer);
		
		// Defining send socket
		int sd;
		struct hostent *server_name;
		char buffer[1024];
		int len;

		memset(&sin, 0, sizeof(sin));

		sd = socket(AF_INET, SOCK_DGRAM, 0);	
		
		//computing the size of the message to be sent to client
		int messageSize = 0;
		for(int j = 0; j < 32; j++)
		{
			if(buffer[j] == 0)
			{
				messageSize = j;
				break;
			}
		}		
		//sending the page_write message to coworker
		if(sendto(sd, buffer, messageSize + 1, 0, (struct sockaddr *) &sin, sizeof(sin)) < 0){
			printf("cannot connect to client%d\n", i);
			return -1;
		}
		close(sd);
	}else if(strcmp(4firstMsgChars, "WRIT") == 0)
	{
		//The command was READ
		char *token;
		int pID;
		int bufferPos=0;
		token = strtok( msg, seps );
		token = strtok(NULL, seps);
		bufferPos = 6+sizeof(token);
		pID = atoi(token);
		writePage(pID,bufferPos,msg,len);
	}
	else
		return -1;
}


int main(void)
{
	int sd;
	struct sockaddr_in addr;
	char msg[32];
	bzero(&addr, sizeof(addr));

	addr.sin_family = AF_INET;
	addr.sin_port = htons(LISTEN_PORT);
	addr.sin_addr.s_addr = INADDR_ANY;

	sd = socket(PF_INET, SOCK_DGRAM, 0);

	if(bind(sd, &addr, sizeof(addr)) != 0){
		printf("Cannot bind to listen on port 8989\n");
		return -1;
	}
	for(ever)
	{
		struct sockaddr_in sin;
		int sin_len = sizeof(sin);
		int len = recvfrom(sd, msg, 32, 0, (struct sockaddr *)&sin, &sin_len);
		msg[len] = 0;
		executeMessage(msg, len, sin);
		//printf("The message is %s\n", msg);
	}
	close(sd);
	return 0;
}
