/* Shared Integers API Impelementation */
#include "SHI.h"

static int segment_id;
static void *shared_memory;

int init_shared(int size,int num)
{
	if ((segment_id=shmget(IPC_PRIVATE, size*num*sizeof(char) ,PERMISSIONS|IPC_CREAT))<0) {
		perror("init: Error in shmget\n");
		return -1;
	}
	shared_memory = shmat(segment_id , 0 , 0);
	return 0;
}

void shi_set(char* value,int length,int num)
{
	for (int i=0;i<length;i++){
		*((char*)(shared_memory+ length*num + i*sizeof(char))) = value[i];
	}
	
}

void shi_get(char * value, int length,int num) 
{
	for (int i=0; i<length ; i++){
		*((char*)(shared_memory + length*num + i*sizeof(char)));
	}
}

int clean_shared()
{
	shmdt(shared_memory);
	if (shmctl(segment_id,IPC_RMID,0)) {
		perror("clean_integers: Error in shmctl");
		return -1;
	}
	return 0;
}
