﻿#include <stdlib.h>
#include "Sem.h"
#include "SHI.h"
#include "SHI2.h"
#include <time.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define serverWait 0

// This is the port on all coworkers through which DSM Server sends datagram requests
#define DATAGRAM_CONNECT_PORT 8989
// This is the port through which DSM server receives datagram responds from coworkers
#define LISTEN_PORT_ALLOC 8990

#define DSM_SERVER_IP_ADDRESS "192.168.0.1"

#define PAGE_MAX_SIZE 1024

#define MY_ID_SHARED_INDEX 0

#define ever ;;


void sendMessageToGameServer(char* message)
{
	// Defining listen socket and connecting to it
	int receive_sd;
	struct sockaddr_in receive_addr;
	// The received message should contain pageID, coworker IP address,
	// and a pointer to beginning of page section on coworker address space
	char receive_msg[12];
	bzero(&receive_addr, sizeof(receive_addr));
	receive_addr.sin_family = AF_INET;
	receive_addr.sin_port = htons(LISTEN_PORT_ALLOC);
	receive_addr.sin_addr.s_addr = INADDR_ANY;
	receive_sd = socket(PF_INET, SOCK_DGRAM, 0);
	if(bind(receive_sd, &receive_addr, sizeof(receive_addr)) != 0){
		printf("Cannot bind to listen port\n");
		return -1;
	}

	// Defining send socket
	
	int sd;
	struct sockaddr_in addr;
	struct hostent *server_name;
	char buffer[1024];
	int len;

	memset(&addr, 0, sizeof(addr));

	addr.sin_family = AF_INET;
	addr.sin_port = htons(DATAGRAM_CONNECT_PORT);
	addr.sin_addr.s_addr = inet_addr(DSM_SERVER_IP_ADDRESS);

	sd = socket(AF_INET, SOCK_DGRAM, 0);
	
	//computing the size of the message to be sent to coworker
	int messageSize = 0;
	for(int j = 0; j < 32; j++)
	{
		if(message[j] == 0)
		{
			messageSize = j;
			break;
		}
	}

	//sending the connect message to server
	if(sendto(sd, message, messageSize + 1, 0, (struct sockaddr *) &addr, sizeof(addr)) < 0){
		printf("cannot connect to coworker%d\n", i);
		return -1;
	}
	close(sd);
	
	//struct sockaddr_in receive_sin;
	//int receive_sin_len = sizeof(receive_sin);
	//int receive_len = recvfrom(receive_sd, receive_msg, 12, 0, (struct sockaddr *)&receive_sin, &receive_sin_len);
	
	//wait for server start signal
	for(ever)
	{
		struct sockaddr_in sin;
		int sin_len = sizeof(sin);
		int len = recvfrom(receive_sd, msg, 32, 0, (struct sockaddr *)&sin, &sin_len);
		msg[len] = 0;
		if (executeMessage(msg, len)>0){
			break;
		}
		//printf("The message is %s\n", msg);
	}
	
}

int executeMessage(const char * msg, int len)
{
	//The first 4 characters of Game server message
	char 4firstMsgChars[4];
	for(int i = 0; i < 4; i++)
		4firstMsgChars[i] = msg[i];
	char seps[] = " ";

    if(strcmp(4firstMsgChars, "STRT") == 0)
	{
		char sep[] = " ";
		char *token;	
		token = strtok( msg, seps );
		token = strtok(NULL, seps);
		int myId = atoi(token);
		shi2_set(MY_ID_SHARED_INDEX,myId);
		return 1;
	}
	return 0;
}

void parseData(char* data,char* sentence , char* clientsScoreString, ){
	char sep[] = "#";
	char *token;	
	token = strtok( msg, seps );
	token = strtok(NULL, seps);
	for (int i=0;i<sizeof(token);i++){
		sentence[i]=token[i];
	}
	sentence[i+1]=0;
	int pnum=0;
	token = strtok(NULL, seps);
	pnum = atoi(token);
	int j =0;
	for (int i=0;i<pnum;i++){
		int cNum=0;
		int cGrade=0;
		token = strtok(NULL, seps);
		cNum = atoi(token);
		token = strtok(NULL, seps);
		cGrade = atoi(token);
		char tempS[20];
		sprintf(tempS,"Client %d :\t%d\n",cNum,cGrade);
		for (int k =0;k<tempSize;k++){
			clientsScoreString[j++]=tempS[k];
		}
	}
	clientsScoreString[j]=0;	
}

int calculateGrade(char * sentence2,char user_char){
	int found = 0;
	for (int i=0;i<sizeof(sentence2);i++){
		if (sentence2[i]==user_char){
			found++;
			sentence2[i]='-';
		}
	}
	return found;
}

/*
	finds and updates my score in shared page.
*/
void updateMyScore(int score,char * data,int myId){
	char dataCopy [ sizeof(data)];
	for (int i=0;i<sizeof(data);i++){
		dataCopy[i] = data [i];
	}
	char sep[] = "#";
	char *token;	
	int bufferPos=0;
	token = strtok( msg, seps );	
	//skip sentence
	token = strtok(NULL, seps);
	bufferPos+=sizeof(token+1);
	int pnum =0;
	token = strtok(NULL, seps)
	bufferPos+=sizeof(token+1);;
	pnum = atoi(token);
	for (int i=0;i<pnum ; i++){
		int clientID=0;
		token = strtok(NULL, seps);		
		clientID = atoi(token);
		if (clientID==myId){
			//my record in DSM found 
			//update it
			char tempS[10];
			sprintf(tempS,"%d",score);
			int j;
			for(j=0;j<sizeof(tempS);j++){
				data[bufferPos+j]=tempS[j];
			}
			int newBufferPos =bufferPos+j;
			bufferPos+=sizeof(token+1);			
			//copy tail of datacopy to data = shift
			for (int k = bufferPos; k<sizeof(dataCopy)-j; k++){
				data[k]=datacopy[newBufferPos++];
			}
			break;
		}		
		//skip score field
		token = strtok(NULL, seps);
	}
}

int main(int argc, char** argv) {
	//initialization
	int j=0;
	int maxP=1;
	pid_t child_pids[maxP];
	struct timespec delay;
	delay.tv_sec = maxsec - 1;
	delay.tv_nsec = 999999999;	
	
	//init local shared memory
	init_shared(PAGE_MAX_SIZE,2);
	init_integers(1);
	//init semaphors
	init_semaphores(1);
    sem_init(serverWait,0);
	
	child_pids[j] = fork();
    if (child_pids[j] == 0){  
		//do the algorithm for entering the server
		sendMessageToGameServer("CNNT");
		
		//2: get data
		char* data;
		dsm_read(pageID,DSM_SERVER_IP_ADDRESS,data);
		//parse data
		char sentence[PAGE_MAX_SIZE];
		char clientsScoreString[1000];
		parseData(data,sentence,clientsScoreString,DSM_SERVER_IP_ADDRESS);
		shi_set(sentence,PAGE_MAX_SIZE,0);
		shi_set(data,PAGE_MAX_SIZE,1);
		//update screen using shared variable in shared memory
		printf(clientsScoreString);
		//signal semaphor serverWait
		sem_signal(serverWait);  //		
		while (true){
			//sleep
			nanosleep(&delay,0);
			//read data
			dsm_read(pageID,DSM_SERVER_IP_ADDRESS,data);
			parseData(data,sentence,clientsScoreString);
			//update screen using shared variable in shared memory
			printf(clientsScoreString);			
		}
		return 0;
    } else if (child_pids[j] < 0){
			printf("error!");
    }
	j++;
	
	//show waiting for server message and wait
	printf("waitng for server");
	//wait for server
	sem_wait(serverWait);   
	char * sentence;
	shi_get(sentence,PAGE_MAX_SIZE);
	char * data;
	shi_get(data,PAGE_MAX_SIZE);	
	//copy sentence
	char sentence2 [PAGE_MAX_SIZE];
	for (int i = 0;i<sizeof(sentence);i++){
		sentence2[i]=sentence[i];
	}
	int myId = shi2_get(MY_ID_SHARED_INDEX);
	int score =0;
	do{
		//1: wait for user input
		int user_char;
		scanf ("%c", &user_char);
		//calculate new grade using (answer)
		score+=calculateGrade(sentence2,user_char);
		//send grades to server using shared memory
		//update shared memory
		updateMyScore(score,data,myId);
		dsm_write(pageID,data, PAGE_MAX_SIZE, );
		//check if game is over?
		//eles go to 1
	while (score == sizeof(sentence));
	
	//send end signal to server
	sendMessageToGameServer("ENDD");
	//finalizing
	clean_semaphores();
	clean_shared();
	return 0;
}