
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>


// This is the port through which DSM server receives datagram responds from coworkers
#define LISTEN_PORT_ALLOC 8989

#define DATAGRAM_CONNECT_PORT 8990

#define ever ;;


int executeMessage(const char * msg, int len)
{
	//The message is either ALLOC, FREE, REPLICATE, EXPAND, READ, or COPY
	//The first 4 characters of DSM server message
	char 4firstMsgChars[4];
	for(int i = 0; i < 4; i++)
		4firstMsgChars[i] = msg[i];
	char seps[] = " ";

    if(strcmp(4firstMsgChars, "CNNT") == 0)
	{
		return 1;
	}
	if(strcmp(4firstMsgChars, "ENDD") == 0)
	{
		return 2;
	}
	return 0;
}

/*
	method that sends a START signal too all connected clients
*/
void sendStart(int clientsNum, sockaddr_in* clientsAddress, int* clientsAddressLen ){
	for (int i = 0; i<clientsNum; i++){
		// Defining send socket
		
		int sd;
		struct hostent *server_name;
		char buffer[1024];
		int len;

		sd = socket(AF_INET, SOCK_DGRAM, 0);

		//building the message to be sent to clients
		char message[32];
		sprintf(message, "STRT %d",i);
		//computing the size of the message to be sent to clients
		int messageSize = 0;
		for(int j = 0; j < 32; j++)
		{
			if(message[j] == 0)
			{
				messageSize = j;
				break;
			}
		}

		//sending the connect message to server
		if(sendto(sd, message, messageSize + 1, 0, (struct sockaddr *) &clientsAddress[i], clientsAddressLen[i]) < 0){
			printf("cannot connect to coworker%d\n", i);
			return -1;
		}
		close(sd);
	}
}

int getSizeOf(char * s){
	int messageSize = 0;
	for(int k = 0; k < 32; k++)
	{
		if(s[k] == 0)
		{
			messageSize = k-1;
			break;
		}
	}
	return messageSize; 
}

int main(int argc, char** argv) {
	if (argc == 3){
		//initialization
		int pnum=atoi(argv[1]);
		char* sentence=argv[2];
		int clients=0;
		//array that preservs clients address
		sockaddr_in clientsSockets [pnum] ;
		int clientsSocketsLen [pnum];
		
		//busy while until all clients connect	
		while(clients<pnum) {
			//create sockets
			// Defining listen socket and connecting to it
			int receive_sd;
			struct sockaddr_in receive_addr;
			
			char receive_msg[12];
			bzero(&receive_addr, sizeof(receive_addr));
			receive_addr.sin_family = AF_INET;
			receive_addr.sin_port = htons(LISTEN_PORT_ALLOC);
			receive_addr.sin_addr.s_addr = INADDR_ANY;
			receive_sd = socket(PF_INET, SOCK_DGRAM, 0);
			
			
			//wait for client connect message
			for(ever)
			{
				if(bind(receive_sd, &receive_addr, sizeof(receive_addr)) != 0){
					printf("Cannot bind to listen port\n");
					return -1;
				}
				struct sockaddr_in sin;
				int sin_len = sizeof(sin);
				int len = recvfrom(receive_sd, msg, 32, 0, (struct sockaddr *)&sin, &sin_len);				
				msg[len] = 0;
				if (executeMessage(msg, len)>0){
					//A client connected add it to clients;
					clientsSockets[clients]=sin;
					clientsSocketsLen[clients]=sin_len;
					clients++;
					receive_sd.close();
					break;
				}
			}			
		}
		
		//create initial values
		char sep = '#';
		char data[1024];
		int i
		for (i = 0;i<sizeof(sentence);i++){
			data[i]=sentence[i];
		}
		data[i++]=sep;
		char tempS [3];
		sprintf(tempS,"%d%c",pnum,sep);
		int tempSize = getSizeof(tempS);
		for (int k=0;k<tempSize;k++){
			data[i++]=tempS[k];
		}
		for (int j = 0;j<pnum;j++){
			char clientString [32];
			sprintf(clientString,"%d%c%d%c",j,sep,0,sep);
			int messageSize = getSizeof(clientString);
			for (int k=0;k<messageSize;k++){
				data[i++]=clientString[k];
			}
		}
		data[i]=0;
		
		//create shared memory and put initial values
		int pageID = dsm_stablish(1024,data,i);
		
		//send start ta all
		for (int numStartSent=0;numStartSent<pnum;numStartSent++){
			sendStart(pnum, clientsSockets,clientsSocketsLen );
		}
		
		//game is running now!
		
		
		//1: wait for a client to send end
		clients=0;
		
		//busy while until all clients end
		while(clients<pnum) {
			//create sockets
			// Defining listen socket and connecting to it
			int receive_sd;
			struct sockaddr_in receive_addr;
			// The received message should contain pageID, coworker IP address,
			// and a pointer to beginning of page section on coworker address space
			char receive_msg[12];
			bzero(&receive_addr, sizeof(receive_addr));
			receive_addr.sin_family = AF_INET;
			receive_addr.sin_port = htons(LISTEN_PORT_ALLOC);
			receive_addr.sin_addr.s_addr = INADDR_ANY;
			receive_sd = socket(PF_INET, SOCK_DGRAM, 0);
			
			
			//wait for client end signal
			for(ever)
			{
				if(bind(receive_sd, &receive_addr, sizeof(receive_addr)) != 0){
					printf("Cannot bind to listen port\n");
					return -1;
				}
				struct sockaddr_in sin;
				int sin_len = sizeof(sin);
				int len = recvfrom(receive_sd, msg, 32, 0, (struct sockaddr *)&sin, &sin_len);
				msg[len] = 0;
				if (executeMessage(msg, len)>0){
					break;
				}
				//printf("The message is %s\n", msg);
			}			
			clients++;
						
			receive_sd.close();
			//wait for all
			
		}
				
		//finalizing
		//delete shared memory structures
		dsm_free(pageID);
		return 0;
	}
    else{
      printf("not enough argument!!");
      return 1;
    }	
	
}
