#include <linux/linkage.h> // for linking a system call
#include <linux/kernel.h>  // for the printk
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

// This is the port on all coworkers through which DSM Server sends datagram requests
#define DATAGRAM_CONNECT_PORT 8989


static int getNewPageID()
{
	static int pageID = 0;
	return pageID++;
}

// the function is to free a page.
asmlinkage int sys_dsm_free(int pageID)
{
	printk(KERN_EMERG "dsm_free is running!");


	// Defining send socket
	int sd;
	struct sockaddr_in addr;
	struct hostent *server_name;
	char buffer[1024];
	int len;

	memset(&addr, 0, sizeof(addr));

	addr.sin_family = AF_INET;
	addr.sin_port = htons(DATAGRAM_CONNECT_PORT);
	addr.sin_addr.s_addr = inet_addr("127.0.0.1");

	sd = socket(AF_INET, SOCK_DGRAM, 0);
	
	//building the message to be sent to coworker
	char message2[32];
	sprintf(message2, "FREE %d", currentPageID);	
	//computing the size of the message to be sent to coworker
	int messageSize = 0;
	for(int j = 0; j < 32; j++)
	{
		if(message[j] == 0)
		{
			messageSize = j;
			break;
		}
	}
	//copy page data to message
	for (int j =0; j < _pageSize; j++){
		message2[++messageSize]=_pageData[j];
	}
	//sending the page_write message to coworker
	if(sendto(sd, message2, messageSize + 1, 0, (struct sockaddr *) &addr, sizeof(addr)) < 0){
		printf("cannot connect to coworker%d\n", i);
		return -1;
	}
	close(sd);

	return 0;
}
