#include <linux/linkage.h> // for linking a system call
#include <linux/kernel.h>  // for the printk
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

// This is the port on all coworkers through which DSM Server sends datagram requests
#define DATAGRAM_CONNECT_PORT 8989

//The port through which recieves data
#define LISTEN_PORT_ALLOC 8893


static int getNewPageID()
{
	static int pageID = 0;
	return pageID++;
}


asmlinkage int sys_dsm_read(int pageID, unsigned char * address, char* buffer)
{
	printk(KERN_EMERG "dsm_read is running!");

	/create socket to middleware
	// Defining listen socket and connecting to it
	int receive_sd;
	struct sockaddr_in receive_addr;
	// The received message should contain pageID, coworker IP address,
	// and a pointer to beginning of page section on coworker address space
	char receive_msg[12];
	bzero(&receive_addr, sizeof(receive_addr));
	receive_addr.sin_family = AF_INET;
	receive_addr.sin_port = htons(LISTEN_PORT_ALLOC);
	receive_addr.sin_addr.s_addr = INADDR_ANY;
	receive_sd = socket(PF_INET, SOCK_DGRAM, 0);
	if(bind(receive_sd, &receive_addr, sizeof(receive_addr)) != 0){
		printf("Cannot bind to listen port\n");
		return -1;
	}

	// Defining send socket
	int sd;
	struct sockaddr_in addr;
	struct hostent *server_name;
	char buffer[1024];
	int len;

	memset(&addr, 0, sizeof(addr));

	addr.sin_family = AF_INET;
	addr.sin_port = htons(DATAGRAM_CONNECT_PORT);
	addr.sin_addr.s_addr = inet_addr("127.0.0.1");

	sd = socket(AF_INET, SOCK_DGRAM, 0);	
	
	//building the message to be sent to coworker
	char message2[32];
	sprintf(message2, "READ %d", pageID);	
	//computing the size of the message to be sent to coworker
	int messageSize = 0;
	for(int j = 0; j < 32; j++)
	{
		if(message[j] == 0)
		{
			messageSize = j;
			break;
		}
	}
	//copy page data to message
	for (int j =0; j < _pageSize; j++){
		message2[++messageSize]=_pageData[j];
	}
	//sending the page_write message to coworker
	if(sendto(sd, message2, messageSize + 1, 0, (struct sockaddr *) &addr, sizeof(addr)) < 0){
		printf("cannot connect to coworker%d\n", i);
		return -1;
	}
	close(sd);
	
	//wait for coworker datas
	for(ever)
	{
		struct sockaddr_in sin;
		int sin_len = sizeof(sin);
		int len = recvfrom(receive_sd, msg, 32, 0, (struct sockaddr *)&sin, &sin_len);
		msg[len] = 0;
		if (len>0){
			buffer = msg;
			break;
		}
	}
	
	return 0;
}
